<?php
session_start();

// Pfad zur Konfigurationsdatei
$config_file = 'config.json';

// Prüfen, ob die Konfigurationsdatei bereits existiert
if (file_exists($config_file)) {
    // Wenn ja, zur Admin-Seite weiterleiten (oder Login-Seite)
    header('Location: admin.php');
    exit;
}

$message = '';

// Formularverarbeitung, wenn das Setup-Formular gesendet wird
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $admin_username = $_POST['admin_username'] ?? '';
    $admin_password = $_POST['admin_password'] ?? '';
    $linktree_name = $_POST['linktree_name'] ?? 'Mein Linktree';

    if (!empty($admin_username) && !empty($admin_password)) {
        // Passwort hashen (für bessere Sicherheit)
        $hashed_password = password_hash($admin_password, PASSWORD_DEFAULT);

        // Standardkonfiguration erstellen
        $config = [
            'admin_username' => $admin_username,
            'admin_password' => $hashed_password,
            'linktree_name' => $linktree_name,
            'favicon' => '',
            'logo' => '',
            'colors' => [
                'text' => '#ffffff',
                'page_bg_type' => 'solid', // solid, gradient, image
                'page_bg_value' => '#1a202c', // Hex-Code, CSS-Gradient oder Bild-URL
                'category_bg_type' => 'solid',
                'category_bg_value' => '#2d3748',
                'linktree_bg_type' => 'solid',
                'linktree_bg_value' => '#4a5568',
            ],
            'category_display' => 'stacked', // stacked or tabs
        ];

        // Konfiguration in JSON speichern
        if (file_put_contents($config_file, json_encode($config, JSON_PRETTY_PRINT))) {
            // **NEUE ÜBERPRÜFUNG HIER:**
            // Verifizieren, ob die Datei korrekt geschrieben wurde und lesbar ist
            $verify_config = json_decode(file_get_contents($config_file), true);

            if (!empty($verify_config) && isset($verify_config['admin_username']) && $verify_config['admin_username'] === $admin_username) {
                // Leere JSON-Dateien für andere Daten erstellen
                file_put_contents('users.json', json_encode([], JSON_PRETTY_PRINT));
                file_put_contents('categories.json', json_encode([], JSON_PRETTY_PRINT));
                file_put_contents('links.json', json_encode([], JSON_PRETTY_PRINT));
                file_put_contents('texts.json', json_encode([], JSON_PRETTY_PRINT));

                // Upload-Verzeichnis erstellen, falls es nicht existiert
                if (!is_dir('uploads')) {
                    mkdir('uploads', 0777, true);
                }

                $message = '<div class="bg-green-500 text-white p-3 rounded-md mb-4">Setup erfolgreich! Sie können sich jetzt anmelden.</div>';
                // Optional: Direkt zur Admin-Seite weiterleiten
                header('Refresh: 3; URL=admin.php');
                exit; // Wichtig, um sicherzustellen, dass keine weiteren Ausgaben gesendet werden
            } else {
                $message = '<div class="bg-red-500 text-white p-3 rounded-md mb-4">Fehler: Konfigurationsdatei konnte nicht korrekt gelesen oder validiert werden nach dem Speichern. Bitte Dateiberechtigungen prüfen.</div>';
                // Optional: Die möglicherweise fehlerhafte config.json löschen, damit Setup erneut versucht werden kann
                // unlink($config_file);
            }
        } else {
            $message = '<div class="bg-red-500 text-white p-3 rounded-md mb-4">Fehler beim Speichern der Konfiguration. Bitte Dateiberechtigungen prüfen.</div>';
        }
    } else {
        $message = '<div class="bg-red-500 text-white p-3 rounded-md mb-4">Bitte füllen Sie alle Felder aus.</div>';
    }
}
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>DigiLinks Setup</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f0f2f5;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }
        .setup-container {
            background-color: #ffffff;
            padding: 2.5rem;
            border-radius: 0.75rem;
            box-shadow: 0 10px 15px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 400px;
            text-align: center;
        }
        .form-group label {
            display: block;
            text-align: left;
            margin-bottom: 0.5rem;
            font-weight: 600;
            color: #4a5568;
        }
        .form-group input {
            width: 100%;
            padding: 0.75rem;
            border: 1px solid #cbd5e0;
            border-radius: 0.375rem;
            margin-bottom: 1rem;
            box-sizing: border-box;
        }
        .form-group button {
            width: 100%;
            padding: 0.75rem;
            background-color: #4c51bf;
            color: white;
            border: none;
            border-radius: 0.375rem;
            font-size: 1.125rem;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }
        .form-group button:hover {
            background-color: #434190;
        }
    </style>
</head>
<body>
    <div class="setup-container">
        <h1 class="text-3xl font-bold text-gray-800 mb-4">DigiLinks Setup</h1>
        <p class="text-gray-600 mb-6">Willkommen! Bitte konfigurieren Sie Ihren Linktree, indem Sie einen Admin-Benutzernamen und ein Passwort festlegen.</p>

        <?php echo $message; // Zeigt Erfolgs- oder Fehlermeldungen an ?>

        <form method="POST">
            <div class="form-group">
                <label for="admin_username">Admin Benutzername:</label>
                <input type="text" id="admin_username" name="admin_username" required>
            </div>
            <div class="form-group">
                <label for="admin_password">Admin Passwort:</label>
                <input type="password" id="admin_password" name="admin_password" required>
            </div>
            <div class="form-group">
                <label for="linktree_name">Linktree Name:</label>
                <input type="text" id="linktree_name" name="linktree_name" value="Mein Linktree">
            </div>
            <div class="form-group">
                <button type="submit">Setup abschließen</button>
            </div>
        </form>
    </div>
</body>
</html>
