<?php
header('Content-Type: application/json');

// Pfad zur Links-JSON-Datei
$links_file = 'links.json';

// Funktion zum Laden von JSON-Daten
function load_json($file) {
    if (file_exists($file)) {
        return json_decode(file_get_contents($file), true);
    }
    return [];
}

// Nur POST-Anfragen zulassen
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Ungültige Anfrage-Methode.']);
    exit;
}

// JSON-Input lesen
$input = json_decode(file_get_contents('php://input'), true);

$entered_password = $input['password'] ?? '';
$link_id = $input['link_id'] ?? '';

// Debugging-Informationen
error_log("DEBUG: verify_link_password.php - Request received.");
error_log("DEBUG: verify_link_password.php - Entered password (first 5 chars): " . substr($entered_password, 0, 5) . (strlen($entered_password) > 5 ? '...' : '') . " (FULL VALUE: " . $entered_password . " - DANGER: PLAIN TEXT IN LOGS)");
error_log("DEBUG: verify_link_password.php - Received link_id: " . $link_id);

if (empty($entered_password) || empty($link_id)) {
    error_log("DEBUG: verify_link_password.php - Missing password or link ID in request.");
    echo json_encode(['success' => false, 'message' => 'Passwort oder Link-ID fehlen.']);
    exit;
}

$links = load_json($links_file);
$found_link = null;

// Debug: Alle Link-IDs in links.json protokollieren
error_log("DEBUG: verify_link_password.php - Links in links.json:");
foreach ($links as $link_item) {
    error_log("DEBUG:    - Link ID in JSON: " . ($link_item['id'] ?? '[ID MISSING]') . " (Name: " . ($link_item['name'] ?? 'N/A') . ")");
}


// Link anhand der ID finden
foreach ($links as $link) {
    if (isset($link['id']) && $link['id'] === $link_id) {
        $found_link = $link;
        break;
    }
}

if (!$found_link) {
    error_log("DEBUG: verify_link_password.php - Link with ID '{$link_id}' not found in links.json.");
    echo json_encode(['success' => false, 'message' => 'Link nicht gefunden.']);
    exit;
}

// Prüfen, ob der Link passwortgeschützt ist und das Passwort verifizieren
if ($found_link['password_protected'] ?? false) {
    $stored_password = $found_link['password'] ?? ''; // Dies ist jetzt der Klartext
    
    error_log("DEBUG: verify_link_password.php - Link '{$link_id}' is password protected.");
    error_log("DEBUG: verify_link_password.php - Stored password for link '{$link_id}' (first 5 chars): " . substr($stored_password, 0, 5) . (strlen($stored_password) > 5 ? '...' : '') . " (FULL VALUE: " . $stored_password . " - DANGER: PLAIN TEXT IN LOGS)");

    if (empty($stored_password)) {
        error_log("DEBUG: verify_link_password.php - Stored password is empty for protected link '{$link_id}'.");
        echo json_encode(['success' => false, 'message' => 'Passwort für diesen Link ist nicht korrekt gesetzt. Bitte kontaktieren Sie den Administrator.']);
        exit;
    }

    // Direkter Vergleich des Klartext-Passworts
    if ($entered_password === $stored_password) {
        error_log("DEBUG: verify_link_password.php - Password verification SUCCESS for link '{$link_id}'.");
        echo json_encode(['success' => true]);
    } else {
        error_log("DEBUG: verify_link_password.php - Password verification FAILED for link '{$link_id}'. Entered password did not match stored password.");
        echo json_encode(['success' => false, 'message' => 'Falsches Passwort.']);
    }
} else {
    // Wenn der Link nicht passwortgeschützt ist, aber diese Anfrage trotzdem gesendet wurde
    error_log("DEBUG: verify_link_password.php - Link '{$link_id}' is NOT password protected. Granting access.");
    echo json_encode(['success' => true]); // Oder eine spezifischere Meldung, dass kein Passwort erforderlich war
}

?>
